#!/usr/bin/perl
##
## vi:ts=4
##
##---------------------------------------------------------------------------##
##  Author:
##      Markus F.X.J. Oberhumer         markus.oberhumer@jk.uni-linz.ac.at
##  Copyright:
##      Copyright (C) 1995, 1996 Markus F.X.J. Oberhumer
##      For conditions of distribution and use, see copyright notice in kb.h 
##  Description:
##      create _kbname.hh from kb.h
##---------------------------------------------------------------------------##

($PROG = $0) =~ s%\\%/%g;

$keys = 0;
%name = ();

#
# read
#

$kb = shift || 'kb.h';
open(FILE,$kb) || die "$PROG: unable to open $kb\n";

while (<FILE>) {

##	                   #   define   KB_SCAN_ESC       1
	next unless (/^\s*\#\s*define\s+KB_SCAN_(\w+)\s+(\w+)/);
	$n = $1; $c = $2;
	next if ($c =~ /^KB_SCAN_/);	# an alias

	unless ($c =~ /^\d+$/) {
		die "$PROG: line $.: invalid scancode $c for $n\n";
	}
	if (defined($name{$c})) {
		die "$PROG: line $.: duplicate entry $c -> $name{$c} $n\n";
	}
##	print STDERR "$PROG: $n $c\n";
	$name{$c} = $n;
	$keys++;

}
close(FILE);

print STDERR "$PROG: $keys key names found\n";

if ($keys == 0) {
	die "$PROG: no keys found !\n";
}

#
# write
#

binmode(STDOUT);		# use unix end-of-line conventions

print <<Header;
/* _kbname.hh -- key names
 * Copyright (C) 1995, 1996 Markus F.X.J. Oberhumer
 * For conditions of distribution and use, see copyright notice in kb.h 
 */

/* WARNING: this file should *not* be used by applications. It is
   part of the implementation of the keyboard library and is
   subject to change. Applications should only use kb.h.
 */


/* DO NOT EDIT - this file is automatically generated by $PROG */


static const char * _kb_key_name[128] = {
Header

for (0..127) {
	local ($n, $s);
	$n = '';
	if (defined($name{$_})) {
		$n = $name{$_};
		$n =~ s/_/ /g;
		$keys--;
	}
	$s = sprintf("\"%s\",", $n);
	printf("\t%-16s\t/* %3d   0x%02x */\n", $s, $_, $_);
}

if ($keys != 0) {
	die "$PROG: $keys keys were not handled !\n";
}

print "};\n\n";
print "\n/*\nvi:ts=4\n*/\n";

exit(0);
